// 
//
// Monitoring Graphs Example plugin
// (c) 2006 Ray Adams
// 
//
//
//
#include "stdafx.h"
#include "resource.h"
#include "winbase.h"
HINSTANCE hinstDLLl;
lppatt_proc Main_Proc;
HWND ATT_Win_Handle;
int InitDone=0;
int ShowTime=0;
int ShowRes=0;
int ShowBat=0;



BOOL APIENTRY DllMain( HANDLE hModule, 
                       DWORD  ul_reason_for_call, 
                       LPVOID lpReserved
					 )
{
    hinstDLLl=(HINSTANCE)hModule;
	return TRUE;
}

void APIENTRY get_plug_info(PPlugInfo Data) {
	strcpy(Data->Menu_Text,"Memory Monitoring");
	Data->PluginType=PL_MGO;
	Data->Sign=ATT_Sign;
}



void APIENTRY exec_plugin (HWND Win_Handle, lppatt_proc ATT_Proc) {
	//Save ATT main window handle
	ATT_Win_Handle=Win_Handle;
	InitDone=1;
}
 
void APIENTRY done_plugin() {
	//Stop Plugin
	//Do something if monitoring closed
}

void APIENTRY start_mr_plugin() {
	//Start Plugin
	//Do something when monitoring started
}


int APIENTRY get_mr_count () {
	//Return monitoring sources count
	return 4;
}

void APIENTRY get_mr_name (int source_index, char* source_name) {
	//Return monitoring source name
	switch (source_index)
	{
	case 0:
		strcpy(source_name,"Memory Load %");
		break;
	case 1:
		strcpy(source_name,"Physical Available (Mb)");
		break;
	case 2:
		strcpy(source_name,"Used Page File (Mb)");
		break;
	case 3:
		strcpy(source_name,"Used Virtual (Mb)");
		break;

	}
}

DWORD APIENTRY get_mr_status (int source_index) {
	//Return status of source 1-enabled , 0-disabled
	switch (source_index)
	{
	case 0:
		return 1;
		break;
	case 1:
		return 1;
		break;
	case 2:
		return 1;
		break;
	case 3:
		return 1;
		break;

	}
	return  0;
}


float APIENTRY get_mr_value (int source_index) {
	//Return monitoring source value
	_MEMORYSTATUSEX ms;
	ms.dwLength = sizeof(ms);
	if (GlobalMemoryStatusEx(&ms)==0)
	{
		return 0;
	}
	switch (source_index)
	{
	case 0:
		return (float)ms.dwMemoryLoad;
		break;
	case 1:
		return (float)(signed __int64)ms.ullAvailPhys / 1024 / 1024;
		break;
	case 2:
		return (float)(signed __int64)(ms.ullTotalPageFile - ms.ullAvailPageFile) / 1024 / 1024;
		break;
	case 3:
		return (float)(signed __int64)(ms.ullTotalVirtual -ms.ullAvailVirtual) / 1024 / 1024;
		break;

	}
	return  0;
}


